#include <bits/stdc++.h>
using namespace std;
using ll = long long;
using ld = long double;
const int N = 2e5 + 20;

int blok;
vector<int> a;
vector<int> freq;
vector<int> cnt;
int maxFreq = 0;

void add(int idx) {
    int val = a[idx];
    cnt[freq[val]]--;
    freq[val]++;
    cnt[freq[val]]++;
    maxFreq = max(maxFreq, freq[val]);
}

void remove1(int idx) {
    int val = a[idx];
    cnt[freq[val]]--;
    if (cnt[freq[val]] == 0 && freq[val] == maxFreq) {
        maxFreq--;
    }
    freq[val]--;
    cnt[freq[val]]++;
}

int gett() {
    return maxFreq;
}

struct Query {
    int l, r, idx;
    bool operator<(const Query &other) const {
        if (l / blok != other.l / blok)
            return l / blok < other.l / blok;
        return (l / blok) & 1 ? r < other.r : r > other.r;
    }
};

void solve(){
    int n;
    cin >> n;
    vector<ll> a1(n);
    for(int i = 0; i < n; i++)cin >> a1[i];

    vector<ll> all = a1;
    vector<ll> pref(n);
    pref[0] = a1[0];
    for(int i = 1; i < n; i++)pref[i] = pref[i-1]+a1[i];
    all.push_back(0);
    all.insert(all.end(),pref.begin(),pref.end());

    sort(all.begin(),all.end());
    all.erase(unique(all.begin(),all.end()),all.end());

    auto compress = [&](ll x) -> int {
        return lower_bound(all.begin(), all.end(), x) - all.begin();
    };

    a.resize(n);
    for(int i = 0; i < n; i++)a[i] = compress(a1[i]);
    for(int i = 0; i < n; i++)pref[i] = compress(pref[i]);

    int sz = all.size() + 10;
    freq.assign(sz,0);
    cnt.assign(n+5,0);

    map<int, int> mp, l, r;
    mp[compress(0)] = 1;
    l[compress(0)] = 0;
    for(int i = 0; i < n; i++){
        if(!mp[pref[i]]){
            mp[pref[i]] = 1;
            l[pref[i]] = i + 1;
        }else{
            mp[pref[i]]++;
            r[pref[i]] = i;
        }
    }

    vector<pair<int, int>> q;
    set<int> vis;
    for(int i = 0; i < n; i++){
        if(mp[pref[i]] > 1 && !vis.count(pref[i])){
            q.emplace_back(l[pref[i]], r[pref[i]]);
            vis.insert(pref[i]);
        }
    }

    int m = q.size();
    blok = sqrt(n)+1;
    vector<Query> q1(m);
    for(int i = 0; i < m; i++){
        q1[i] = {q[i].first,q[i].second, i};
    }
    sort(q1.begin(),q1.end());

    vector<int> ans(m);
    int l1 = 0, r1 = -1;
    maxFreq = 0;
    fill(freq.begin(),freq.end(),0);
    fill(cnt.begin(),cnt.end(),0);

    for(auto query : q1){
        while(l1 > query.l)add(--l1);
        while(r1 < query.r)add(++r1);
        while(l1 < query.l)remove1(l1++);
        while(r1 > query.r)remove1(r1--);
        ans[query.idx] = gett();
    }

    int ans1 = 0;
    for(int i = 0; i < m; i++){
        ans1 = max(ans1, ans[i]);
    }
    cout << ans1;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    ll t;
    t = 1;
    //cin >> t;
    while(t--){
        solve();
    }

}